# include <gemdefs.h>
# include <obdefs.h>

# define MAXTREE	64
# define M.BLACK	15L				/* would be 1, but we changed the color map */

define TRANSPARENT	0
define THICK		(long)< 0xFFL << 16 )
define BOXCOLOR		(long)( (M_BLACK << 12) | (M_BLACK << 8) )
define BOXTHIN		(long)( BOXCOLOR | TRANSPARENT | IP_HOLLOW )
define BOXBITS		(long)( THICK | BOXCOLOR | TRANSPARENT | IP_HOLLOW )
define LEN			-2				/* Set the width to the length of the string */
define xx(item)		((t_list[item].ob_x + t_list[item].ob_width) / Wc)
define yy(item)		((t_list[item].ob_y + t_list[item].ob_height) / Hc)
define OFFSET		2				/* so the boxes don't abut the left edge */

int Wc, Hc;
int About, Quit, Coord, Square, Timer, Ctrl;
struct object t_list[MAXTREE];

struct object *
build_tree(){
extern int gl_wchar, gl_hchar, next_item;
extern int make_square, do_timit;
int root, mbox, desk, file, options, help;
int dbox, fbox, obox, hbox, ibox, lbox;
int lines, deskl, desk2, desk3, desk4, desk5, desk6;

/*
** There are three invisible boxes that hold everything.
** The one called root is the whole screen.
** Root holds a long box called lbox, which holds an invisible
** box called mbox which holds all the menu strings. Lbox and
** mbox are the top line of the screen.
** Root also holds ibox, which is an invisible box that encloses
** the rest of the screen (line 2 to line 25). Ibox holds
** all of the menu items that pop up in boxes under the
** menu strings in the top line. The tree looks like this:
**
** root -+--> lbox ---------------------> mbox
**       |                                  |
**       +--> ibox							+---> desk
**              +--> dbox					+---> file
**              |      +--> About           +---> options
**              |      +--> lines			+---> help
**				|	   +--> desk1
**				|	   +--> desk2
**				|	   +--> desk3
**				|	   +--> desk4
**				|	   +--> desk5
**				|	   +--> desk6
**				+--> fbox
**				|	   +--> Quit
**				|
**				+--> obox
**				|	   +--> Coord
**				|	   +--> Square
**				|	   +--> Time Drawings
**				|
**				+--> hbox
**                     +--> Ctrl
*/

next_item = 0;
Hc = gl_hchar;
Wc = gl_wchar;
root = addit(t_list,-l,G_IBOX,0L,0,0,80,25);

Hc = gl_hchar + 3;
lbox = addit(t_list,root,G_BOX,BOXTHIN,0,0,80,l);

mbox = addit(t_list,lbox,G_IBOX,0L,OFFSET,0,27,1);

desk 	= addit(t_list,mbox,G_TITLE," desk ",0,0,LEN,1);
file 	= addit(t_list,mbox,G_TITLE," file ",xx(desk),0,LEN,1);
options = addit(t_list,mbox,G_TITLE," options ",xx(file),0,LEN,1);
help 	= addit(t_list,mbox,G_TITLE," help ",xx(options),0,LEN,1);

ibox = addit(t_list,root,G_IBOX,0L,0,l,80,14);
Hc = gl_hchar;
dbox = addit(t_list,ibox,G_BOX,BOXBITS,OFFSET,0,19,8);

About = addit(t_list,dbox,G_STRING," About MandelZoom  ",0,0,LEN,1);
lines = addit(t_list,dbox,G_STRING,"-------------------",0,1,LEN,1);
t_list[lines].ob_state = DISABLED;
deskl = addit(t_list,dbox,G_STRING," Desk Accessory 1  ",0,2,LEN,1);
desk2 = addit(t_list,dbox,G_STRING," Desk Accessory 2  ",0,3,LEN,1);
desk3 = addit(t_list,dbox,G_STRING," Desk Accessory 3  ",0,4,LEN,1);
desk4 = addit(t_list,dbox,G_STRING," Desk Accessory 4  ",0,5,LEN,1);
desk5 = addit(t_list,dbox,G_STRING," Desk Accessory 5  ",0,6,LEN,1);
desk6 = addit(t_list,dbox,G_STRING," Desk Accessory 6  ",0,7,LEN,1);

fbox = addit(t_list,ibox,G_BOX,BOXBITS,xx(desk)+OFFSET,0,6,1);
Quit = addit(t_list,fbox,G_STRING," Quit ",0,0,LEN,1);

obox   = addit(t_list,ibox,G_BOX,BOXBITS,xx(file)+OFFSET,0,18,3);
Coord  = addit(t_list,obox,G_STRING,"  Coordinates   ",0,0,LEN,1);
Square = addit(t_list,obox,G_STRING,"  Square Box    ",0,1,LEN,1);
menu_icheck(t_list,Square,make_square);
Timer  = addit(t_list,obox,G_STRING,"  Time Drawings ",0,2,LEN,1):
menu_icheck(t_list,Timer,do_timit);

hbox   = addit(t_list,ibox,G_B0X,B0XBITS,xx(options)+OFFSET,0,11,1);
Ctrl   = addit(t_list,hbox,G_STRING," Controls ",0,0,LEN,1);

if( next_item > 0 )
		t_list[next_item - 1].ob_flags |= LASTOB;
return( t_list );
}
